require "EPII_prerenderUI"

--------------------------------------------------------------------------------
-- Helper function for setting variables with the values set via ModOptions ----
--------------------------------------------------------------------------------

if ModOptions and ModOptions.getInstance then
	local EPIIOptionsLookups = {}

	EPIIOptionsLookups.searchMovementDelay = { 0, 250, 500, 750, 1000, 1500, 2000, 2500, 3000, 3500, 4000, 5000 }
	EPIIOptionsLookups.searchPerformanceDelay = { 0, 125, 250, 375, 500, 625, 750, 875, 1000, 1250, 1500, 2000 }
	
	EPIIOptionsLookups.iconSize = { 15, 30, 45, 60, 75, 90, 120, 150, 180, 210, 240, 270, 300 }
	EPIIOptionsLookups.iconPadding = {0, 2, 3, 4, 5, 10, 15, 20, 25, 30 }
	EPIIOptionsLookups.iconAlpha = { 1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1 }

	EPIIOptionsLookups.maxIconColumns = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 }
	EPIIOptionsLookups.maxIconRows = EPIIOptionsLookups.maxIconColumns

	function EPIIOnModOptionsApply(optionValues)
		EasyPlacedItemIcons.searchForAll = optionValues.settings.options.searchForAll
		
		EasyPlacedItemIcons.requireAiming = optionValues.settings.options.requireAiming
		
		if EasyPlacedItemIcons.keypressMode ~= optionValues.settings.options.keypressMode then
			EasyPlacedItemIcons.resetKeypressToggle()
		end
		EasyPlacedItemIcons.keypressMode = optionValues.settings.options.keypressMode
		
		EasyPlacedItemIcons.searchMovementDelay = EPIIOptionsLookups.searchMovementDelay[optionValues.settings.options.searchMovementDelay]
		EasyPlacedItemIcons.searchPerformanceDelay = EPIIOptionsLookups.searchPerformanceDelay[optionValues.settings.options.searchPerformanceDelay]

		EasyPlacedItemIcons.iconSize = EPIIOptionsLookups.iconSize[optionValues.settings.options.iconSize]
		EasyPlacedItemIcons.iconPadding = EPIIOptionsLookups.iconPadding[optionValues.settings.options.iconPadding]
		EasyPlacedItemIcons.iconAlpha = EPIIOptionsLookups.iconAlpha[optionValues.settings.options.iconAlpha]
		
		EasyPlacedItemIcons.maxIconColumns = EPIIOptionsLookups.maxIconColumns[optionValues.settings.options.maxIconColumns]
		EasyPlacedItemIcons.maxIconRows = EPIIOptionsLookups.maxIconRows[optionValues.settings.options.maxIconRows]
		
		EasyPlacedItemIcons.useMoreIcon = optionValues.settings.options.useMoreIcon
		EasyPlacedItemIcons.useIconHighlight = optionValues.settings.options.useIconHighlight
	end

	function EPIIOnModOptionsApplyInGame(optionValues)
		EPIIOnModOptionsApply(optionValues)
		
		EasyPlacedItemIcons.applyPanelOptions()
	end


--------------------------------------------------------------------------------
-- Option definition table for ModOptions --------------------------------------
--------------------------------------------------------------------------------

	local EPIIData = {
		options_data = {
			searchForAll = {
				name = "IGUI_EPII_Search_For_All",
				tooltip = "IGUI_EPII_Search_For_All_Tooltip",
				default = false,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},		
			
			requireAiming = {
				name = "IGUI_EPII_Require_Aiming",
				tooltip = "IGUI_EPII_Require_Aiming_Tooltip",
				default = true,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},		

			keypressMode = {
				getText("IGUI_EPII_Keypress_Mode_Hold"), getText("IGUI_EPII_Keypress_Mode_Toggle"),
				getText("IGUI_EPII_Keypress_Mode_Disabled"),
				
				name = "IGUI_EPII_Keypress_Mode",
				tooltip = "IGUI_EPII_Keypress_Mode_Tooltip",
				default = 1,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},

			searchMovementDelay = {
				-- choices in seconds (will be converted to milliseconds when applied):
				getText("IGUI_EPII_No_Delay"), "0.25" .. getText("IGUI_EPII_Units_Seconds"), 
				"0.5" .. getText("IGUI_EPII_Units_Seconds"), "0.75" .. getText("IGUI_EPII_Units_Seconds"), 
				"1" .. getText("IGUI_EPII_Units_Second"), "1.5" .. getText("IGUI_EPII_Units_Seconds"), 
				"2" .. getText("IGUI_EPII_Units_Seconds"), "2.5" .. getText("IGUI_EPII_Units_Seconds"), 
				"3" .. getText("IGUI_EPII_Units_Seconds"), "3.5" .. getText("IGUI_EPII_Units_Seconds"), 
				"4" .. getText("IGUI_EPII_Units_Seconds"), "5" .. getText("IGUI_EPII_Units_Seconds"),

				name = "IGUI_EPII_Search_Movement_Delay",
				tooltip = "IGUI_EPII_Search_Movement_Delay_Tooltip",
				default = 1,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},
			
			searchPerformanceDelay = {
				-- choices in seconds (will be converted to milliseconds when applied):
				getText("IGUI_EPII_No_Delay"), "0.125" .. getText("IGUI_EPII_Units_Seconds"), 
				"0.25" .. getText("IGUI_EPII_Units_Seconds"), "0.375" .. getText("IGUI_EPII_Units_Seconds"), 
				"0.5" .. getText("IGUI_EPII_Units_Seconds"), "0.625" .. getText("IGUI_EPII_Units_Seconds"), 
				"0.75" .. getText("IGUI_EPII_Units_Seconds"), "0.875" .. getText("IGUI_EPII_Units_Seconds"), 
				"1" .. getText("IGUI_EPII_Units_Second"), "1.25" .. getText("IGUI_EPII_Units_Seconds"), 
				"1.5" .. getText("IGUI_EPII_Units_Seconds"), "2" .. getText("IGUI_EPII_Units_Seconds"),
				
				name = "IGUI_EPII_Search_Performance_Delay",
				tooltip = "IGUI_EPII_Search_Performance_Delay_Tooltip",
				default = 1,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},
			
			iconSize = {
				"15" .. getText("IGUI_EPII_Units_Pixels"), 
				"30" .. getText("IGUI_EPII_Units_Pixels"), "45" .. getText("IGUI_EPII_Units_Pixels"), 
				"60" .. getText("IGUI_EPII_Units_Pixels"), "75" .. getText("IGUI_EPII_Units_Pixels"), 
				"90" .. getText("IGUI_EPII_Units_Pixels"), "120" .. getText("IGUI_EPII_Units_Pixels"),
				"150" .. getText("IGUI_EPII_Units_Pixels"), "180" .. getText("IGUI_EPII_Units_Pixels"),
				"210" .. getText("IGUI_EPII_Units_Pixels"), "240" .. getText("IGUI_EPII_Units_Pixels"),
				"270" .. getText("IGUI_EPII_Units_Pixels"), "300" .. getText("IGUI_EPII_Units_Pixels"),
				
				name = "IGUI_EPII_Icon_Size",
				tooltip = "IGUI_EPII_Icon_Size_Tooltip",
				default = 4,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},
			
			iconPadding = {
				getText("IGUI_EPII_No_Padding"), "2" .. getText("IGUI_EPII_Units_Pixels"), 
				"3" .. getText("IGUI_EPII_Units_Pixels"), "4" .. getText("IGUI_EPII_Units_Pixels"), 
				"5" .. getText("IGUI_EPII_Units_Pixels"), "10" .. getText("IGUI_EPII_Units_Pixels"), 
				"15" .. getText("IGUI_EPII_Units_Pixels"), "20" .. getText("IGUI_EPII_Units_Pixels"),
				"25" .. getText("IGUI_EPII_Units_Pixels"), "30" .. getText("IGUI_EPII_Units_Pixels"),
				
				name = "IGUI_EPII_Icon_Padding",
				tooltip = "IGUI_EPII_Icon_Padding_Tooltip",
				default = 5,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},

			iconAlpha = {
				getText("IGUI_EPII_No_Transparency"), "90%", "80%", "70%", "60%", "50%", "40%", "30%", "20%", "10%",
				
				name = "IGUI_EPII_Icon_Alpha",
				tooltip = "IGUI_EPII_Icon_Alpha_Tooltip",
				default = 4,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},
			
			maxIconColumns = {
				"1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
				
				name = "IGUI_EPII_Max_Icon_Columns",
				tooltip = "IGUI_EPII_Max_Icon_Columns_Tooltip",
				default = 3,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},

			maxIconRows = {
				"1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
				
				name = "IGUI_EPII_Max_Icon_Rows",
				tooltip = "IGUI_EPII_Max_Icon_Rows_Tooltip",
				default = 3,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},

			useMoreIcon = {
				name = "IGUI_EPII_Use_More_Icon",
				tooltip = "IGUI_EPII_Use_More_Icon_Tooltip",
				default = true,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},		

			useIconHighlight = {
				name = "IGUI_EPII_Use_Icon_Highlight",
				tooltip = "IGUI_EPII_Use_Icon_Highlight_Tooltip",
				default = true,
				OnApplyMainMenu = EPIIOnModOptionsApply,
				OnApplyInGame = EPIIOnModOptionsApplyInGame,
			},		
				
		},

		mod_id = 'EasyPlacedItemIcons',
		mod_shortname = 'Placed Item Icons',
		mod_fullname = 'Easy Placed Item Icons',
	}

	local key_data = {
		key = Keyboard.KEY_LSHIFT,
		name = "EPII_Activation_Key",
	}

	local category = "[EPII_Keybind_Category]";
	
	ModOptions:AddKeyBinding(category, key_data);
	
	ModOptions:getInstance(EPIIData)
	
	ModOptions:loadFile()
	
	Events.OnGameStart.Add(function() EPIIOnModOptionsApplyInGame({ settings=EPIIData }) end);
else
	local category = { value="[EPII_Keybind_Category]" };
    local key_data = {
        key = Keyboard.KEY_LSHIFT,
        value = "EPII_Activation_Key",
    }
	
	table.insert(keyBinding, category)
    table.insert(keyBinding, key_data)
	
	Events.OnGameStart.Add(EasyPlacedItemIcons.applyPanelOptions);
end